﻿using System;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.EFR;
using System.Web.Security.AntiXss;

public partial class DoDFragmentLabDelete : BasePage
{
    private DoDFragmentManager _manager = new DoDFragmentManager();
    protected readonly string DoDFragmentPage = "DoDFragment.aspx?patientId="; 
                                                
    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
        HiddenFieldDoDFragmentLabID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentLabId"], false);

        DOD_FRAGMENT_LAB lab = _manager.GetDoDFragmentLabById(Helpers.GetIntFromString(Request.QueryString["dodFragmentLabId"].ToString()));
        lab.SetAsChangeTrackingRoot();
        lab.SetAsDeleteOnSubmit();

        _manager.Update(lab);

        ResponseRedirect(DoDFragmentPage, HiddenFieldPatientID.Value);
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

    private void ResponseRedirect(string destination, string queryString)
    {
        string queryStringValue = string.Empty;
        if (queryString != null)
            queryStringValue = AntiXssEncoder.UrlEncode(queryString);

        string destinationUrl = string.Concat(destination, queryStringValue);
        string currentHost = Request.Url.Host;
        if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            Server.Transfer(destinationUrl);
    }
}